/*
 * Decompiled with CFR 0.152.
 */
package tfar.toughnessbar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tfar.toughnessbar.ToughnessBar;

public class EventHandlerClient {
    private final ResourceLocation TEXTURE = new ResourceLocation("toughnessbar", "textures/gui/toughness.png");
    private final List<Integer> colors = new ArrayList<Integer>();
    private static final Minecraft mc = Minecraft.m_91087_();
    int lastToughness = 0;
    static Index[] indexes;

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderArmorToughnessEvent(RenderGameOverlayEvent.PostLayer event) {
        if (event.getOverlay() == ForgeIngameGui.FOOD_LEVEL_ELEMENT) {
            ForgeIngameGui forgegui;
            if (EventHandlerClient.mc.f_91065_ instanceof ForgeIngameGui && !(forgegui = (ForgeIngameGui)EventHandlerClient.mc.f_91065_).shouldDrawSurvivalElements()) {
                return;
            }
            if (mc.m_91288_() instanceof LivingEntity) {
                LivingEntity viewEntity = (LivingEntity)mc.m_91288_();
                int armorToughness = Mth.m_14107_((double)viewEntity.m_21051_(Attributes.f_22285_).m_22135_());
                if (armorToughness < 1) {
                    return;
                }
                if (this.colors.isEmpty()) {
                    ((List)ToughnessBar.ToughnessBarConfig.ClientConfig.colorValues.get()).stream().filter(hexColor -> hexColor.startsWith("#")).forEach(hexColor -> this.colors.add(Integer.parseInt(hexColor.substring(1), 16)));
                    if (this.colors.isEmpty()) {
                        this.colors.add(0xFFFFFF);
                    }
                }
                if (this.lastToughness != armorToughness) {
                    this.calculateIndex(armorToughness);
                }
                int layer = (int)Math.ceil((double)armorToughness / 20.0) - 1;
                int color = this.getColor(layer);
                int previous = this.getColor(layer - 1);
                RenderSystem.m_69478_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.TEXTURE);
                PoseStack pose = event.getMatrixStack();
                pose.m_85836_();
                int subt = EventHandlerClient.mc.f_91065_ instanceof ForgeIngameGui ? ((ForgeIngameGui)EventHandlerClient.mc.f_91065_).right_height : 0;
                int top = mc.m_91268_().m_85446_() - subt;
                int right = mc.m_91268_().m_85445_() / 2 + 82;
                block10: for (int i = 0; i < 10; ++i) {
                    Index index = indexes[i];
                    if (layer > 0) {
                        switch (index) {
                            case empty: {
                                this.drawFullIcon(pose, previous, i, right, top);
                                break;
                            }
                            case half: {
                                this.drawSplitIcon(pose, previous, color, i, right, top);
                                break;
                            }
                            case full: {
                                this.drawFullIcon(pose, color, i, right, top);
                            }
                        }
                        continue;
                    }
                    switch (index) {
                        case empty: {
                            if (!((Boolean)ToughnessBar.ToughnessBarConfig.ClientConfig.empty.get()).booleanValue()) continue block10;
                            this.drawEmptyIcon(pose, color, i, right, top);
                            continue block10;
                        }
                        case half: {
                            this.drawHalfIcon(pose, color, i, right, top);
                            continue block10;
                        }
                        case full: {
                            this.drawFullIcon(pose, color, i, right, top);
                        }
                    }
                }
                if (EventHandlerClient.mc.f_91065_ instanceof ForgeIngameGui) {
                    ((ForgeIngameGui)EventHandlerClient.mc.f_91065_).right_height += 10;
                }
                pose.m_85849_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
                RenderSystem.m_69461_();
            }
        }
    }

    void calculateIndex(int armorToughness) {
        indexes = new Index[]{Index.empty, Index.empty, Index.empty, Index.empty, Index.empty, Index.empty, Index.empty, Index.empty, Index.empty, Index.empty};
        int modulo = armorToughness % 20;
        if (modulo == 0) {
            indexes = new Index[]{Index.full, Index.full, Index.full, Index.full, Index.full, Index.full, Index.full, Index.full, Index.full, Index.full};
            return;
        }
        int fullicons = modulo / 2;
        boolean halficon = armorToughness % 2 == 1;
        for (int i = 0; i < fullicons; ++i) {
            EventHandlerClient.indexes[i] = Index.full;
        }
        if (halficon) {
            EventHandlerClient.indexes[fullicons] = Index.half;
        }
        this.lastToughness = armorToughness;
    }

    private int getColor(int index) {
        return index < 0 ? 0xFFFFFF : (index >= this.colors.size() ? this.colors.get(this.colors.size() - 1) : this.colors.get(index));
    }

    private void drawEmptyIcon(PoseStack stack, int color, int i, int guiLeft, int guiTop) {
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 256.0f), (float)((float)(color >> 8 & 0xFF) / 256.0f), (float)((float)(color & 0xFF) / 256.0f), (float)1.0f);
        EventHandlerClient.mc.f_91065_.m_93228_(stack, guiLeft - i * 8, guiTop, 18, 0, 9, 9);
    }

    private void drawFullIcon(PoseStack stack, int color, int i, int guiLeft, int guiTop) {
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 256.0f), (float)((float)(color >> 8 & 0xFF) / 256.0f), (float)((float)(color & 0xFF) / 256.0f), (float)1.0f);
        EventHandlerClient.mc.f_91065_.m_93228_(stack, guiLeft - i * 8, guiTop, 9, 0, 9, 9);
    }

    private void drawHalfIcon(PoseStack stack, int color, int i, int guiLeft, int guiTop) {
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 256.0f), (float)((float)(color >> 8 & 0xFF) / 256.0f), (float)((float)(color & 0xFF) / 256.0f), (float)1.0f);
        if (((Boolean)ToughnessBar.ToughnessBarConfig.ClientConfig.empty.get()).booleanValue()) {
            this.drawEmptyIcon(stack, color, i, guiLeft, guiTop);
        }
        EventHandlerClient.mc.f_91065_.m_93228_(stack, guiLeft - i * 8, guiTop, 0, 0, 9, 9);
    }

    private void drawSplitIcon(PoseStack stack, int color1, int color2, int i, int guiLeft, int guiTop) {
        this.drawFullIcon(stack, color1, i, guiLeft, guiTop);
        RenderSystem.m_157429_((float)((float)(color2 >> 16 & 0xFF) / 256.0f), (float)((float)(color2 >> 8 & 0xFF) / 256.0f), (float)((float)(color2 & 0xFF) / 256.0f), (float)1.0f);
        EventHandlerClient.mc.f_91065_.m_93228_(stack, guiLeft - i * 8, guiTop, 0, 9, 9, 9);
    }

    static enum Index {
        half,
        full,
        empty;

    }
}

